<?php
session_start();
date_default_timezone_set('Asia/Manila');

// Database connection
$conn = new mysqli("localhost", "hisgqmlh_sda", "bm]~gTM]2MpY", "hisgqmlh_sda");

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $date = $_POST['date'] ?? '';
    $reason = $_POST['reason'] ?? '';

    if (!empty($date) && !empty($reason)) {
        // Use prepared statement for SELECT
        $stmt_check = $conn->prepare("SELECT id FROM holidays WHERE date = ?");
        $stmt_check->bind_param("s", $date);
        $stmt_check->execute();
        $result = $stmt_check->get_result();

        if ($result && $result->num_rows == 0) {
            // Use prepared statement for INSERT
            $stmt = $conn->prepare("INSERT INTO holidays (date, description) VALUES (?, ?)");
            $stmt->bind_param("ss", $date, $reason);
            if ($stmt->execute()) {
                $stmt->close();
                $stmt_check->close();
                // Redirect to logs.php after successful addition (no output before header!)
                header("Location: logs.php?added=1");
                exit();
            } else {
                $message = "⚠️ Failed to add holiday. Please try again.";
                $stmt->close();
                $stmt_check->close();
            }
        } else {
            $message = "⚠️ Date already exists in the holidays list.";
            $stmt_check->close();
        }
    } else {
        $message = "⚠️ Please complete all fields.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Add Class Suspension / Holiday</title>
    <style>
        body {
            font-family: Arial;
            background-color: #121212;
            color: #fff;
            text-align: center;
            padding: 40px;
        }
        .form-box {
            background-color: #1e1e1e;
            display: inline-block;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 12px rgba(0, 0, 0, 0.4);
        }
        input[type="date"], input[type="text"] {
            padding: 10px;
            width: 250px;
            margin: 10px;
            border: 1px solid #666;
            border-radius: 5px;
            background: #2c2c2c;
            color: #fff;
        }
        button {
            padding: 10px 20px;
            margin-top: 10px;
            background-color: #0d6efd;
            color: white;
            border: none;
            border-radius: 5px;
        }
        button:hover {
            background-color: #0b5ed7;
        }
        .btn-back {
            display: inline-block;
            padding: 10px 20px;
            background-color: #6c757d;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-size: 14px;
        }
        .btn-back:hover {
            background-color: #5a6268;
        }
        .message {
            margin-top: 15px;
            font-weight: bold;
        }
        img.flag {
            width: 40px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body class="dark">
    <img src="ph_flag.png" class="flag" alt="🇵🇭">
    <h2>📅 Add Class Suspension / Holiday</h2>

    <div class="form-box">
        <form method="POST" autocomplete="off">
            <input type="date" name="date" required><br>
            <input type="text" name="reason" placeholder="Reason (e.g. Typhoon Egay)" required><br>
            <button type="submit">Add Suspension</button>
        </form>
        <?php if (!empty($message)): ?>
            <div class="message"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>
    </div>

    <div style="text-align: center; margin-top: 25px;">
        <a href="dashboard.php" class="btn-back">← Back to Dashboard</a>
    </div>
</body>
</html>