<?php
/*
 * HASH GENERATOR
 * Unsaon Paggamit:
 * 1. Ilisi ang value sa $password_nga_gusto_nimo sa password nga gusto nimo i-hash.
 * 2. I-upload ni sa imong server.
 * 3. Ablihi sa browser (e.g., http://your-ip/hash_generator.php).
 * 4. Kopyaha ang resulta nga hash ug i-paste sa 'password' column sa imong database.
*/

// --- I-EDIT ANG PASSWORD DINHI ---
$password_nga_gusto_nimo = 'password123'; // Pwede nimo ni ilisan sa lain

// --- DILI NA KAILANGAN I-EDIT ANG UBOS ---

// I-generate ang secure hash gamit ang standard nga pamaagi sa PHP
$hashed_password = password_hash($password_nga_gusto_nimo, PASSWORD_DEFAULT);

// I-display ang resulta sa nindot nga pormat para dali kopyahon
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PHP Password Hash Generator</title>
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif; line-height: 1.6; padding: 20px; background-color: #f4f4f4; color: #333; }
        .container { max-width: 700px; margin: 40px auto; padding: 30px; background-color: #fff; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.1); }
        h1 { color: #0056b3; }
        p { font-size: 1.1em; }
        code {
            display: block;
            background-color: #e3e3e3;
            padding: 15px;
            border-radius: 5px;
            font-family: "Courier New", Courier, monospace;
            font-size: 1.1em;
            word-wrap: break-word;
            border: 1px solid #ccc;
        }
        .note { color: #c7254e; background-color: #f9f2f4; padding: 15px; border-radius: 5px; margin-top: 20px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>PHP Password Hash Generator</h1>
        <p>Ang hash para sa imong password nga <strong>"<?php echo htmlspecialchars($password_nga_gusto_nimo); ?>"</strong> kay:</p>
        
        <code><?php echo htmlspecialchars($hashed_password); ?></code>

        <p class="note"><strong>Sunod nga Buhaton:</strong> Kopyaha kining tibuok hash sa taas ug i-paste sa <code>password</code> column sa imong <code>users</code> table sa phpMyAdmin para sa user nga imong gusto i-reset ang password.</p>
    </div>
</body>
</html>